///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   XSVD.h - Test Extraction Ephemeris Processing header file
// 
//
//   DESCRIPTION
//
//   Function prototypes for extracting, decodeing, and writeing ephemeris data to a file.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\XSVD.H_V  $
//   
//      Rev 1.15   06 Nov 1998 17:47:54   phungh
//   Labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the write to file code
//   portion out of the interrupt hander so that
//   data is not missed because of time spent
//   too long in the interrupt handler.
//   
//      Rev 1.5   Jul 09 1997 10:32:12   COLEJ
//    
//   
//      Rev 1.4   Feb 12 1997 16:04:50   COLEJ
//    
//   
//      Rev 1.3   Aug 19 1996 17:11:40   COLEJ
//    
//   
//      Rev 1.2   Aug 16 1996 16:57:02   COLEJ
//   Added extraction of raw almanac to a file.
//   
//      Rev 1.1   Aug 15 1996 08:49:10   COLEJ
//    
//   
//      Rev 1.0   Aug 14 1996 18:21:14   COLEJ
//   Header file for SV data extraction file (XSVD.C).
//   
//
//
////////////////////////////////////////////////////////////////////////////////


// define parameter name constants
#define     MA       "Mean Anomaly................................ "
#define     MMD      "Mean Motion Difference...................... "
#define     ECC      "Eccentricity................................ "
#define     SRA      "Square Root of the Semi-Major Axis.......... "
#define     LOPAN    "Longitude of Orbit Plane Ascending Node..... "
#define     IA       "Inclination Angle........................... "
#define     AP       "Argument of Perigee......................... "
#define     RRA      "Rate of Right Ascension..................... "
#define     RIA      "Rate of Inclination Angle................... "
#define     LCC      "Latitude Cosine Correction.................. "
#define     LSC      "Latitude Sine Correction.................... "
#define     ORCC     "Orbital Radius Cosine Correction............ "
#define     ORSC     "Orbital Radius Sine Correction.............. "
#define     IACC     "Inclination Angle Cosine Correction......... "
#define     IASC     "Inclination Angle Sine Correction........... "
#define     ERT      "Ephemeris Reference Time.................... "
#define     EID1     "First Ephemeris Issue of Data...............  "
#define     EID2     "Second Ephemeris Issue of Data..............  "
#define     CID      "Issue of Data,Clock.........................  "
#define     ART      "Almanac Reference Time...................... "
#define     DELI     "Delta I..................................... "
#define     AF0      "Almanac Constant Time Parameter............. "
#define     AF1      "Almanac First Order Time Term............... "
#define     A0       "A0.......................................... "
#define     A1       "A1.......................................... "
#define     DTLS     "Delta tLS................................... "
#define     TOT      "tot......................................... "
#define     WNT      "WNt......................................... "
#define     WNLSF    "WNLSF....................................... "
#define     DN       "DN.......................................... "
#define     DTLSF    "Delta tLSF.................................. "

// define units of measure
#define     MT       " Meters"
#define     RD       " Radians"
#define     SC       " Seconds"
#define     NU       " No Units"
#define     SPS      " Sec/Sec"
#define     WK       " Weeks"
#define     DY       " Days"

//#define     _Debug   TRUE
#define     _Debug   FALSE

#define     CNTL_Z   '\032'    // eof marker in DOS text files

typedef struct{
   unsigned long      pa;      // preamble for debugging only
   unsigned long      IODC;    // only 8 LSB of IODC
   unsigned long      IODE1;   // sfid(2)   sfn(2) bits 0-7      (8bits)
   unsigned long      IODE2;   // sfid(3)   sfn(9) bits 0-7      (8bits)
   unsigned long      IDOT;    // sfid(3)   sfn(9) bits 8-21     (14bits)
   unsigned long      deltan;  // sfid(2)   sfn(3) bits 0-15     (16bits)
   unsigned long      toe;     // sfid(2)   sfn(9) bits 0-15     (16bits)
   unsigned long      OmegaDot;// sfid(3)   sfn(8) bits 0-23     (24bits) 
   unsigned long      Crc;     // sfid(3)   sfn(6) bits 0-15     (16bits)
   unsigned long      Crs;     // sfid(2)   sfn(2) bits 8-23     (16bits)
   unsigned long      Cuc;     // sfid(2)   sfn(5) bits 0-15     (16bits)
   unsigned long      Cus;     // sfid(2)   sfn(7) bits 0-15     (16bits)
   unsigned long      Cic;     // sfid(3)   sfn(2) bits 0-15     (16bits)
   unsigned long      Cis;     // sfid(3)   sfn(4) bits 0-15     (16bits)

   unsigned long      M01;      // sfid(2)   sfn(3-MSB) bits 16-23  (8bits)
   unsigned long      M02;      // sfid(2)   sfn(4-LSB) bits 0-23   (24bits)

   unsigned long      e1;       // sfid(2)   sfn(5-MSB) bits 16-23  (8bits)
   unsigned long      e2;       // sfid(2)   sfn(6-LSB) bits 0-23   (24bits)

   unsigned long      sqrA1;    // sfid(2)   sfn(7-MSB) bits 16-23  (8bits)
   unsigned long      sqrA2;    // sfid(2)   sfn(8-LSB) bits 0-23   (24bits)
   
   unsigned long      Omega01;  // sfid(3)   sfn(2-MSB) bits 16-23  (8bits)
   unsigned long      Omega02;  // sfid(3)   sfn(3-LSB) bits 0-23   (24bits)

   unsigned long      i01;      // sfid(3)   sfn(4-MSB) bits 16-23  (8bits)
   unsigned long      i02;      // sfid(3)   sfn(5-LSB) bits 0-23   (24bits)
   
   unsigned long      omega1;   // sfid(3)   sfn(6-MSB) bits 16-23  (8bits)
   unsigned long      omega2;   // sfid(3)   sfn(7-LSB) bits 0-23   (24bits)

} ephtype;


typedef struct{
   unsigned long      pa;      // preamble for debugging only
   unsigned long      e;         // sfid(4 or 5)   sfn(2) bits 8-23  (16bits)
   unsigned long      toa;
   unsigned long      deltai;
   unsigned long      OmegaDot;
   unsigned long      sqrA;
   unsigned long      Omega0;
   unsigned long      omega;
   unsigned long      M0;
   unsigned long      af0;
   unsigned long      af1; 
} almtype;

typedef struct{
   unsigned long      sv;        // svid
   unsigned long      dw1;       // preamble bits 0-7
   unsigned long      dw2;       // subframe id bits 20-22
   unsigned long      dw3;       // svid bits 2-7, e bits 8-23
   unsigned long      dw4;       // toa bits 0-7, delta i bits 8-23
   unsigned long      dw5;       // Omega dot bits 0-15, sv health bits 16-23
   unsigned long      dw6;       // sqrt A bits 0-23
   unsigned long      dw7;       // Omega 0 bits 0-23
   unsigned long      dw8;       // omega bits 0-23
   unsigned long      dw9;       // M0 bits 0-23
   unsigned long      dw10;      // af0(msb) bits 0-7, af1(msb) bits 8-15, af1(lsb) bits 16-18, af0(lsb) bits 19-21
} rawalmtype;


typedef struct{
   unsigned long      a0;
   unsigned short     a0s;        // used to hold 8 LSBs of A0 until merged
   unsigned long      a1;
   unsigned long      deltatls;
   unsigned long      tot;
   unsigned long      wnt;
   unsigned long      wnlsf;
   unsigned long      dn;
   unsigned long      deltatlsf;     
} utctype;


typedef union{
   unsigned long ulval;
   float          fval;
}             varitype;


typedef union{
   ephtype          ephstruct;
   unsigned long    epharray[26];
}                   ephconv;


typedef union{
   almtype          almstruct;
   unsigned long    almarray[11];
}                   almconv;

typedef union{
   rawalmtype       rawalmstruct;
   unsigned long    rawalmarray[11];
}                   rawalmconv;


#define     SIZE_EPH  sizeof(ephtype) 
#define     SIZE_ALM  sizeof(almtype) 
#define     SIZE_UL   sizeof(unsigned long)
               
void xeph(unsigned long dw, unsigned short prn, unsigned short index);
void xalm(unsigned long dw, unsigned short index);
void xutc(unsigned long dw, unsigned short svid, unsigned short index);
unsigned long gbits(unsigned long temp1, int first, int last);   
unsigned long mword(unsigned long temp1, unsigned long temp2);
float UL2F(unsigned long temp1, int numbits, int scale, char type); 
void svout();
void showmessage(char *message, unsigned short type, unsigned short number);
